﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="Measurements.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Masters.Measurement.Measurements" %>
<%@ MasterType VirtualPath="~/Admin/Ei8htPOS.Master" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
        <Services>
            <asp:ServiceReference Path="~/Admin/WebService/AzvicService.asmx" />
        </Services>
    </asp:ScriptManager>
    <div class="pageheader">
        <h2>
            <i class="fa fa-arrows-alt"></i>Measurements
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../../Dashboard.aspx">Ei8ht POS</a></li>
                <li class="active">Measurements</li>
            </ol>
        </div>
    </div>
    <div class="main searchFields">
        <div class="row">
            <div class="pull-right">
                <asp:HyperLink ID="lnkAddMeasurement" runat="server" CssClass="btn-lg btn btn-primary loading"
                    NavigateUrl="~/Admin/Masters/Measurement/EditMeasurement.aspx">New Measurement</asp:HyperLink>
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                Search Word :
            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtSearch" runat="server" CssClass="textbox w100p" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite"></div>
            <div class="col-md-4 col-xs-12">
                <asp:Button ID="btnSearch" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Search"
                    OnClick="btnSearch_Click" />
                &nbsp;&nbsp;&nbsp;
                        <asp:Button ID="btnShowAll" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Show All"
                            OnClick="btnShowAll_Click" />
            </div>
        </div>
    </div>

    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Measurements</h1>
            <div class="pull-right">
                <asp:Button runat="server" ID="btnExport" OnClick="btnExportToExcel" CssClass="btn-lg btn btn-primary" Text="Export" />
            </div>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
            <asp:GridView runat="server" ID="grdProductMeasurement" AllowPaging="true" PageSize="30"
            CssClass="table" Width="98%" GridLines="Both" AutoGenerateColumns="false"
            OnPageIndexChanging="grdProductMeasurement_PageIndexChanging">
            <Columns>
                <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                    HeaderText="Sl. No.">
                    <ItemTemplate>
                        <%# Container.DataItemIndex + 1  %>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                    <ItemStyle HorizontalAlign="Center"></ItemStyle>
                </asp:TemplateField>
                <asp:BoundField HeaderText="Measurement Name" DataField="MeasurementName" />
                <%--<asp:BoundField HeaderText="Display Order" DataField="SequenceNo" />--%>
                <asp:TemplateField HeaderText="Display Order">
                            <ItemTemplate>
                                <asp:TextBox ID="TextBox1" runat="server" Text='<%# Eval("SequenceNo") %>' data-SizeID='<%# Eval("UniqueID") %>' Style="min-width: 100px !important; width: 100px;" onfocus="OnEditStart(this);" onblur="OnEditComplete(this);" onkeypress="return IsNumeric(event)"  />
                                <img src="../../Images/Loading_cafe.gif" style="display: none;" />
                            </ItemTemplate>
                        </asp:TemplateField>
                <asp:TemplateField HeaderText="Status">
                    <ItemTemplate>
                        <%#bool.Parse(DataBinder.Eval(Container.DataItem, "IsActive").ToString()) ? "Active" : "Inactive"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:HyperLinkField DataNavigateUrlFields="UniqueID" DataNavigateUrlFormatString="~/Admin/Masters/Measurement/EditMeasurement.aspx?UniqueID={0}"
                    Text="Edit" HeaderText="Control" />
            </Columns>
            <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                Position="TopAndBottom" />
           <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None" 
                       Font-Bold="true" Font-Size="Medium" />

            <HeaderStyle CssClass="tbl-header" />
            <RowStyle CssClass="tbl-row" />
            <AlternatingRowStyle CssClass="tbl-row" />
            <EmptyDataRowStyle />
            <EmptyDataTemplate>
                No Record found
            </EmptyDataTemplate>
            <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
        </asp:GridView>
                </div>
            </div>
          </section>
    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>


</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script>
        var initialValue = '';

        function OnEditComplete(txtbox) {
            var FinalValue = $(txtbox).val();
            if (FinalValue != '') {
                if (initialValue != FinalValue) {
                    //Update the Product Quantity
                    $(txtbox).siblings('img').show();
                    var SizeID = $(txtbox).attr('data-SizeID');
                    AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.UpdateSize(SizeID, FinalValue, OnSuccessUpdate, OnError);
                }
            }
            else {
                $(txtbox).val(initialValue);
            }
            $(txtbox).css('border', '1px solid rgb(226,226,226)');
        }
        function OnEditStart(txtbox) {
            initialValue = $(txtbox).val();
            $(txtbox).css('border', '1px double rgba(192, 0, 0, 0.94)');
        }

        function OnSuccessUpdate(result) {
            $('#<%= grdProductMeasurement.ClientID %> tr td input[data-SizeID=' + result.UniqueID + ']').siblings('img').hide();
        }
        function OnError(result) {
            ShowAlert(result.message, 'Error in updating the values during this time. Please try again later.');
        }

    </script>
</asp:Content>
